/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.ntutil;

import filenet.vw.ntutil.RegKeyException;
import filenet.vw.ntutil.VWNTUTIL_DLL;

public class RegKey {
    private static String[] rootKeyDesc;
    private int m_rootID = 0;
    private String m_subKey = null;
    private int m_access = 0;
    private long m_hKey = 0L;
    private StringBuffer m_desc = new StringBuffer();
    private static final int MAX_KEYID = 2;
    public static final int HKCR = 0;
    public static final int HKLM = 1;
    public static final int HKCU = 2;
    public static final int KEYOPEN_CREATE = 1;
    public static final int KEYOPEN_READ = 2;
    public static final int KEYOPEN_WRITE = 4;
    public static final int KEYOPEN_ALL = 7;

    private static native void initIDs();

    private native long open(int var1, String var2, int var3) throws RegKeyException;

    public void openEx(int rootID, String subKey, int access) throws RegKeyException {
        if (rootID > 2 || rootID < 0) {
            throw new RegKeyException("Not supported rootID.");
        }
        this.m_rootID = rootID;
        this.m_subKey = subKey;
        this.m_access = access;
        this.m_hKey = this.open(this.m_rootID, this.m_subKey, this.m_access);
        if (this.m_hKey != 0L) {
            this.m_desc.append(rootKeyDesc[this.m_rootID]);
            this.m_desc.append(this.m_subKey);
        }
    }

    public RegKey(int rootID, String subKey, int access) throws RegKeyException {
        this.openEx(rootID, subKey, access);
    }

    public RegKey(int rootID, String subKey) throws RegKeyException {
        this.openEx(rootID, subKey, 2);
    }

    public RegKey() {
    }

    public native void close();

    public native void flush();

    public native int getIntValue(String var1);

    public native String getStringValue(String var1);

    public native void setValue(String var1, String var2);

    public native void setValue(String var1, int var2);

    public native void deleteSubKey(String var1);

    public native String[] getSubKeyNames();

    public native String[] getValueNames();

    public int getIntValue(String name, int defval) {
        try {
            return this.getIntValue(name);
        }
        catch (Throwable e) {
            System.out.println("getIntValue! Throwable=" + e.getMessage());
            return defval;
        }
    }

    public String getStringValue(String name, String defval) {
        try {
            return this.getStringValue(name);
        }
        catch (Throwable e) {
            System.out.println("getStringValue! Throwable=" + e.getMessage());
            return defval;
        }
    }

    public String toString() {
        return this.m_desc.toString();
    }

    public RegKey[] getSubKeys() {
        try {
            int nSubKeys;
            String[] subKeys = this.getSubKeyNames();
            int n = nSubKeys = subKeys == null ? 0 : subKeys.length;
            if (nSubKeys > 0) {
                RegKey[] res = new RegKey[nSubKeys];
                for (int i = 0; i < nSubKeys; ++i) {
                    res[i] = new RegKey(this.m_rootID, this.m_subKey + "\\" + subKeys[i], this.m_access);
                }
                return res;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    static {
        if (VWNTUTIL_DLL.initLibrary()) {
            RegKey.initIDs();
        }
        rootKeyDesc = new String[]{"HKEY_CLASSES_ROOT\\", "HKEY_LOCAL_MACHINE\\", "HKEY_CURRENT_USER\\"};
    }
}

